/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts;

import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.TableDataSourceBlockPos;
import ivorius.reccomplex.gui.TableDataSourceBlockState;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellTitle;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.network.PacketWorldDataHandler;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.script.WorldScriptHolder;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceWorldScriptHolder
extends TableDataSourceSegmented {
    public WorldScriptHolder script;
    protected TableNavigator tableNavigator;
    protected TableDelegate tableDelegate;
    protected BlockPos pos2;

    public TableDataSourceWorldScriptHolder(WorldScriptHolder script, BlockPos worldPos, TableNavigator tableNavigator, TableDelegate tableDelegate) {
        this.script = script;
        this.tableNavigator = tableNavigator;
        this.tableDelegate = tableDelegate;
        this.addSegment(0, () -> {
            if (script.worldData == null) {
                TableCellButton cell = new TableCellButton(null, null, IvTranslations.get((String)"reccomplex.worldscript.holder.capture"));
                cell.addAction(() -> PacketWorldDataHandler.capture(script, worldPos, this.pos2));
                return cell;
            }
            TableCellButton cell = new TableCellButton(null, null, IvTranslations.get((String)"reccomplex.worldscript.holder.delete"));
            cell.addAction(() -> {
                script.worldData = null;
                tableDelegate.reloadData();
            });
            return cell;
        }, () -> {
            TableCellButton cell = new TableCellButton(null, null, IvTranslations.get((String)"reccomplex.worldscript.holder.switch"));
            cell.addAction(() -> PacketWorldDataHandler.swap(script, worldPos));
            cell.setEnabled(script.worldData != null);
            return cell;
        });
        TableDataSourceBlockPos cellPoint1 = new TableDataSourceBlockPos(script.origin, p -> {
            script.origin = p;
        }, IvTranslations.get((String)"reccomplex.worldscript.holder.point.1"), IvTranslations.getLines((String)"reccomplex.worldscript.holder.point.1.tooltip"));
        cellPoint1.setEnabled(() -> script.worldData == null);
        this.addSegment(1, cellPoint1);
        this.pos2 = script.worldData != null ? script.origin.func_177971_a((Vec3i)BlockPositions.fromIntArray((int[])Structures.size(script.worldData, null))).func_177982_a(-1, -1, -1) : script.origin.func_177982_a(0, 0, 0);
        TableDataSourceBlockPos cellPoint2 = new TableDataSourceBlockPos(this.pos2, p -> {
            this.pos2 = p;
        }, IvTranslations.get((String)"reccomplex.worldscript.holder.point.2"), IvTranslations.getLines((String)"reccomplex.worldscript.holder.point.2.tooltip"));
        cellPoint2.setEnabled(() -> script.worldData == null);
        this.addSegment(2, cellPoint2);
        this.addSegment(3, () -> new TitledCell(new TableCellTitle(null, IvTranslations.get((String)"reccomplex.worldscript.holder.self")).withTooltip(IvTranslations.getLines((String)"reccomplex.worldscript.holder.self.tooltip"))));
        this.addSegment(4, new TableDataSourceBlockState(script.replaceState, s -> {
            script.replaceState = s;
        }, tableNavigator, tableDelegate));
    }

    @Override
    @Nonnull
    public String title() {
        return "Holder";
    }
}

